# formbay-client
Formbay Server API

This Python package is automatically generated by the [formbay Codegen](https://github.com/formbay-api/formbay) project:

- API version: 0.1
- Package version: 1.0.0
- Build package: io.formbay.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import formbay_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import formbay_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import formbay_client
from formbay_client.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = formbay_client.AuthenticationApi(formbay_client.ApiClient(configuration))
username = 'username_example' # str |  (optional)
password = 'password_example' # str |  (optional)
basic_token = 'basic_token_example' # str |  (optional)

try:
    api_response = api_instance.login(username=username, password=password, basic_token=basic_token)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthenticationApi->login: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://trading.formbay.com.au*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**login**](docs/AuthenticationApi.md#login) | **POST** /formbay/token | 
*ClientAPIDocDetailsApi* | [**client_api_pv_doc_post**](docs/ClientAPIDocDetailsApi.md#client_api_pv_doc_post) | **POST** /client_api/pv_doc | 
*ClientAPIDocDetailsApi* | [**client_api_pv_docs_list_post**](docs/ClientAPIDocDetailsApi.md#client_api_pv_docs_list_post) | **POST** /client_api/pv_docs_list | 
*ClientAPIGETAddressDetailsApi* | [**client_api_postcodes_get**](docs/ClientAPIGETAddressDetailsApi.md#client_api_postcodes_get) | **GET** /client_api/postcodes | 
*ClientAPIGETAddressDetailsApi* | [**client_api_street_types_get**](docs/ClientAPIGETAddressDetailsApi.md#client_api_street_types_get) | **GET** /client_api/street_types | 
*ClientAPIGETAddressDetailsApi* | [**client_api_unit_types_get**](docs/ClientAPIGETAddressDetailsApi.md#client_api_unit_types_get) | **GET** /client_api/unit_types | 
*ClientAPIGETTechnicianDetailsApi* | [**client_api_pv_designers_get**](docs/ClientAPIGETTechnicianDetailsApi.md#client_api_pv_designers_get) | **GET** /client_api/pv_designers | 
*ClientAPIGETTechnicianDetailsApi* | [**client_api_pv_electricians_get**](docs/ClientAPIGETTechnicianDetailsApi.md#client_api_pv_electricians_get) | **GET** /client_api/pv_electricians | 
*ClientAPIGETTechnicianDetailsApi* | [**client_api_pv_installers_get**](docs/ClientAPIGETTechnicianDetailsApi.md#client_api_pv_installers_get) | **GET** /client_api/pv_installers | 
*ClientAPIGeneralDetailsApi* | [**client_api_client_get**](docs/ClientAPIGeneralDetailsApi.md#client_api_client_get) | **GET** /client_api/client | 
*ClientAPIGeneralDetailsApi* | [**client_api_clients_get**](docs/ClientAPIGeneralDetailsApi.md#client_api_clients_get) | **GET** /client_api/clients | 
*ClientAPIGeneralDetailsApi* | [**client_api_installation_status_get**](docs/ClientAPIGeneralDetailsApi.md#client_api_installation_status_get) | **GET** /client_api/installation_status | 
*ClientAPIGeneralDetailsApi* | [**client_api_pv_recs_calculator_post**](docs/ClientAPIGeneralDetailsApi.md#client_api_pv_recs_calculator_post) | **POST** /client_api/pv_recs_calculator | 
*ClientAPIGetPVSystemDetailsApi* | [**client_api_pv_inverter_battery_brands_get**](docs/ClientAPIGetPVSystemDetailsApi.md#client_api_pv_inverter_battery_brands_get) | **GET** /client_api/pv_inverter_battery_brands | 
*ClientAPIGetPVSystemDetailsApi* | [**client_api_pv_inverter_battery_models_get**](docs/ClientAPIGetPVSystemDetailsApi.md#client_api_pv_inverter_battery_models_get) | **GET** /client_api/pv_inverter_battery_models | 
*ClientAPIGetPVSystemDetailsApi* | [**client_api_pv_inverter_brands_get**](docs/ClientAPIGetPVSystemDetailsApi.md#client_api_pv_inverter_brands_get) | **GET** /client_api/pv_inverter_brands | 
*ClientAPIGetPVSystemDetailsApi* | [**client_api_pv_inverter_models_get**](docs/ClientAPIGetPVSystemDetailsApi.md#client_api_pv_inverter_models_get) | **GET** /client_api/pv_inverter_models | 
*ClientAPIGetPVSystemDetailsApi* | [**client_api_pv_inverter_series_get**](docs/ClientAPIGetPVSystemDetailsApi.md#client_api_pv_inverter_series_get) | **GET** /client_api/pv_inverter_series | 
*ClientAPIGetPVSystemDetailsApi* | [**client_api_pv_panel_brands_get**](docs/ClientAPIGetPVSystemDetailsApi.md#client_api_pv_panel_brands_get) | **GET** /client_api/pv_panel_brands | 
*ClientAPIGetPVSystemDetailsApi* | [**client_api_pv_panel_models_get**](docs/ClientAPIGetPVSystemDetailsApi.md#client_api_pv_panel_models_get) | **GET** /client_api/pv_panel_models | 
*ClientAPIPVFormDetailsApi* | [**client_api_create_form_post**](docs/ClientAPIPVFormDetailsApi.md#client_api_create_form_post) | **POST** /client_api/create_form | 
*ClientAPIPVFormDetailsApi* | [**client_api_pv_form_delete**](docs/ClientAPIPVFormDetailsApi.md#client_api_pv_form_delete) | **DELETE** /client_api/pv_form | 
*ClientAPIPVFormDetailsApi* | [**client_api_pv_form_docs_get**](docs/ClientAPIPVFormDetailsApi.md#client_api_pv_form_docs_get) | **GET** /client_api/pv_form_docs | 
*ClientAPIPVFormDetailsApi* | [**client_api_pv_form_get**](docs/ClientAPIPVFormDetailsApi.md#client_api_pv_form_get) | **GET** /client_api/pv_form | 
*ClientAPIPVFormDetailsApi* | [**client_api_pv_form_list_get**](docs/ClientAPIPVFormDetailsApi.md#client_api_pv_form_list_get) | **GET** /client_api/pv_form_list | 
*ClientAPIPVFormDetailsApi* | [**client_api_pv_form_put**](docs/ClientAPIPVFormDetailsApi.md#client_api_pv_form_put) | **PUT** /client_api/pv_form | 
*ClientAPIPVFormDetailsApi* | [**client_api_pv_submit_job_post**](docs/ClientAPIPVFormDetailsApi.md#client_api_pv_submit_job_post) | **POST** /client_api/pv_submit_job | 
*ClientAPIPVFormDetailsApi* | [**client_api_pv_validate_job_post**](docs/ClientAPIPVFormDetailsApi.md#client_api_pv_validate_job_post) | **POST** /client_api/pv_validate_job | 
*ClientAPISWHFormDetailsApi* | [**client_api_swh_form_delete**](docs/ClientAPISWHFormDetailsApi.md#client_api_swh_form_delete) | **DELETE** /client_api/swh_form | 
*ClientAPISWHFormDetailsApi* | [**client_api_swh_form_get**](docs/ClientAPISWHFormDetailsApi.md#client_api_swh_form_get) | **GET** /client_api/swh_form | 
*ClientAPISWHFormDetailsApi* | [**client_api_swh_form_list_get**](docs/ClientAPISWHFormDetailsApi.md#client_api_swh_form_list_get) | **GET** /client_api/swh_form_list | 
*ClientAPISWHFormDetailsApi* | [**client_api_swh_form_post**](docs/ClientAPISWHFormDetailsApi.md#client_api_swh_form_post) | **POST** /client_api/swh_form | 
*ClientAPISWHFormDetailsApi* | [**client_api_swh_form_put**](docs/ClientAPISWHFormDetailsApi.md#client_api_swh_form_put) | **PUT** /client_api/swh_form | 
*ClientAPISWHSystemDetailsApi* | [**client_api_swh_brands_get**](docs/ClientAPISWHSystemDetailsApi.md#client_api_swh_brands_get) | **GET** /client_api/swh_brands | 
*ClientAPISWHSystemDetailsApi* | [**client_api_swh_models_get**](docs/ClientAPISWHSystemDetailsApi.md#client_api_swh_models_get) | **GET** /client_api/swh_models | 

## Documentation For Models

 - [AdditionalDocsSchema](docs/AdditionalDocsSchema.md)
 - [ClientApiCreateFormBody](docs/ClientApiCreateFormBody.md)
 - [ClientApiPvDocBody](docs/ClientApiPvDocBody.md)
 - [ClientApiPvDocsListBody](docs/ClientApiPvDocsListBody.md)
 - [ClientApiPvRecsCalculatorBody](docs/ClientApiPvRecsCalculatorBody.md)
 - [ClientApiPvSubmitJobBody](docs/ClientApiPvSubmitJobBody.md)
 - [ClientApiPvValidateJobBody](docs/ClientApiPvValidateJobBody.md)
 - [ClientApiSwhFormBody](docs/ClientApiSwhFormBody.md)
 - [ClientDetailsSchema](docs/ClientDetailsSchema.md)
 - [CreatePvFormSchema](docs/CreatePvFormSchema.md)
 - [FormbayTokenBody](docs/FormbayTokenBody.md)
 - [LoginSuccess](docs/LoginSuccess.md)
 - [PvDocPostSchema](docs/PvDocPostSchema.md)
 - [PvFormGetSchema](docs/PvFormGetSchema.md)
 - [PvRecsCalculatorSchema](docs/PvRecsCalculatorSchema.md)
 - [PvSubmitJobPostSchema](docs/PvSubmitJobPostSchema.md)
 - [StreetTypeGetSchema](docs/StreetTypeGetSchema.md)
 - [SwhFormCreateSchema](docs/SwhFormCreateSchema.md)
 - [SwhFormGetSchema](docs/SwhFormGetSchema.md)
 - [SwhFormGetSchemaDocs](docs/SwhFormGetSchemaDocs.md)
 - [UnitTypeGetSchema](docs/UnitTypeGetSchema.md)

## Documentation For Authorization


## bearerAuth



## Author


